-- 6_onTouch
    
function setup()
    -- prepare any object with x,y,w,h fields, here a button
    button = {
    x = WIDTH/2,
    y = HEIGHT/2,
    w = WIDTH/4,
    h = HEIGHT/4,
    txt = "touch me (slide in, out)",
    colorOff = color(255, 190, 0, 255), -- button color in false state
    colorOn = color(0, 133, 255, 255), -- button color
    state = false
    }
    button.update = function(self)
        if self.state 
        then self.color = self.colorOn
        else self.color = self.colorOff
        end
    end
    button:update()
    -- ############### and add a Sensor to it  #################
    button.sensor = Sensor{ parent=button, xywhMode=RADIUS }
    button.sensor:onTouch( function(event)
        button.state = event.state
        button:update()
    end)
    -- ############### #################  #################
end
function touched(t)
    -- ######### add this in your touched function #########
    if button.sensor:touched(t) then return true end
end
function draw()
    noStroke()
    background(178, 178, 178, 255)     
    fill(button.color)
    rectMode(RADIUS)
    rect(button.x,button.y,button.w,button.h)
    fill(57, 57, 57, 255)         -- set color for text
    fontSize(50)            -- set font size
    textAlign(CENTER)
    textWrapWidth(button.w*1.8)
    text(button.txt,button.x,button.y)       -- draw text on screen)      
end
